﻿//============================================
// filename: main.c
// chip    : CSU38F20
// author  :
// date    : 2020-12-07
//============================================
#include "CSU38F20.h"
#include "i2c.h"

unsigned char i2c_receive_data[5]={0};
unsigned char i2c_trans_data[5] = {0x12,0xC5,0x73,0x5F,0xA5};
unsigned char i = 0;
unsigned char j = 0;
//============================================
// interrupt function
//============================================
void INT_FUNCTION(void) interrupt
{
	if(I2C_RIF && I2C_RIE)			//应尽量减少中断中的处理内容，以防止发生接收溢出，需要及时将数据读出，否则会影响从机数据发送
	{
		I2C_RIF = 0;
		i2c_receive_data[i++] = I2CDAT;		//硬件读取I2CDAT或接收到数据都会清I2CTIF，这样在读取完成后，I2CDAT为空时，I2CTIF依然为0，
		if(i>4)
		{
			i=0;
		}
	}
	else if(I2C_TIF && I2C_TIE)		//I2CDAT为空时，I2CTIF置1，若使能中断，则会向I2CDAT填入数据
	{
		I2C_TIF = 0;
		
		I2CDAT = i2c_trans_data[j++];
		if(j>4)
		{
			j=0;
		}
	}
	else if(I2C_STIF && I2C_STIE)
	{
		I2C_STIF = 0;
		I2CDAT = 0x89;
	}
}

//============================================
// program start
//============================================
void main()
{
	i2c_init();		//i2c从机地址设为0x26，PT5.2为SDA，PT5.3为SCL
	while(1)
	{
		asm("clrwdt");
		asm("nop");
		asm("nop");
	}
}
